library("gplots")
cccol <- c("#CE0013","#16557A","#C7A609","#87C232","#64C0AB","#A14C94","#15A08C","#8B7E75","#1E7CAF","#EA425F","#46489A","#E50033","#0F231F","#1187CD")
cccol50 <- c("#CE001370","#16557A70","#C7A60970","#87C23270","#64C0AB70","#A14C9470","#15A08C70","#8B7E7570","#1E7CAF70","#EA425F70","#46489A70","#E5003370","#0F231F70","#1187CD70")

logfpkm <- read.table("../data/2nd.reprogramming.lg2.all.fpkm.txt",header=T,row.names=1)
npath <- c("hiF_r1","hiF_r2","he0_r1","he0_r2","he2_r1","he2_r2","he6_r1","he6_r2","n8_r1","n8_r2","n8_r3","n12_r1","n12_r2","n14_r1","n14_r2","n14_r3","n20_r1","n20_r2","n20_r3","n24p_r1","n24p_r2","n24m_r1","n24m_r2","niPS_r1","niPS_r2")
fpkm <- round(2**logfpkm-1,5)

logfpkm1 <- read.table("../data/1st.reprogramming.lg2.all.fpkm.txt",header=T,row.names=1)
fm2path <- c("fm2")

genes <- intersect(rownames(logfpkm),rownames(logfpkm1))
plot_data <- cbind(logfpkm1[genes,fm2path],logfpkm[genes,npath])
colnames(plot_data) <- c("hiF",npath)

# tmp_data <- logfpkm[,npath]
# getcoverGnum <- function(indata){
#   return(length(which(indata > 0)))
# }
# apply(tmp_data,2,getcoverGnum)

n_deg <- read.table("Gfold/cutoff.0.58/naive.2nd.deg")[,1]

############ MDS
d <- dist(t(plot_data)) # euclidean distances between the rows
fit <- cmdscale(d,eig=TRUE, k=2) # k is the number of dim
# plot solution 
x <- fit$points[,1]
y <- fit$points[,2]
pdf("Fig2B.pdf",width=7,height=4.5)
cols=c(rep(cccol50[13],1),rep(cccol50[1],2),rep(cccol50[2],2),rep(cccol50[3],2),rep(cccol50[4],2),rep(cccol50[5],3),rep(cccol50[6],2),rep(cccol50[7],3),rep(cccol50[8],3),rep(cccol50[9],2),rep(cccol50[10],2),rep(cccol50[11],2))
plot(x, y, xlab="Coordinate 1", ylab="Coordinate 2", main="naive",pch=19,col=cols,cex=3,ylim=c(-50,100),xlim=c(-100,120))
legend("topright", c("hiF","hiF-T","0d","2d","6d","8d","12d","14d","20d","24d+dox","24d-dox","niPSC-T"), col=c(cccol50[13],cccol50[1:11]),pch=19,bty="n",ncol = 2,cex=1)
dev.off()

#############################
CorrelationHalfPanel <- function(cor_matrix){
	len <- ncol(cor_matrix)
	for (each in seq(len-1)){
		cor_matrix[each,(each+1):len] <- NA
	}
	return(cor_matrix)
}

plot_data <- logfpkm[,npath]
colnames(plot_data) <- npath
sample_cor <- cor(plot_data)
half_cor <- CorrelationHalfPanel(sample_cor)

sample_tree <- hclust(dist(t(plot_data)), method = "average")
cluster_order <- sample_tree$labels[sample_tree$order]
cluster_half_cor <- CorrelationHalfPanel(sample_cor[cluster_order,cluster_order])

pdf("SF2A.half.panel.pdf",width=6,height=6)
par(mar=c(2,2,2,2))
plotMatrix <- half_cor
all_exp <- as.matrix(plotMatrix) # using same scale bar
zmax <- max(na.omit(all_exp))
zmin <- min(na.omit(all_exp))
ColorRamp <- colorRampPalette(c("#F2FAB0","red"), bias=1)(1000)   #color list
ColorLevels <- seq(to=zmax,from=zmin, length=1000)   #number sequence
image(1:ncol(plotMatrix), 1:nrow(plotMatrix), t(plotMatrix), axes=F, col=ColorRamp, xlab="", main="",ylab="")
# axis(side=2,1:ncol(plotMatrix),labels=row.names(plotMatrix),las=2)
dev.off()

pdf("SF2A.legend.pdf",width=3,height=1.8)
par(mar=c(4,2,4,2))
image(ColorLevels,1,matrix(data=ColorLevels, nrow=length(ColorLevels),ncol=1),col=ColorRamp, xlab="",ylab="",cex.axis=2,xaxt="n",yaxt="n",useRaster=T)
axis(side=1,c(zmin,round((zmax-zmin)/2,1),zmax),labels=c(round(zmin,2),round((zmax-zmin)/2,1),round(zmax,1)))
dev.off()
